/*
 Fill-form-from-history Tool (F3H) for ArcPad
 by Mel Meng
 ymeng@dlz.com
 Feb, 2009
 Whatis it?
 F3H is a combobox control which lists the recent 5 entries.
 Selecting an entry in the control will populate the current
 form with values from the selected entry.
 Why is it?
 Close features share similar attributes. Being able to quickly copy values from previous entries
 can greatly reduce the time required for entering repeating values.
 How to use it?
 Go to the Configuration Section and follow the instruction.
 */
//*Configuration Section -- Start*

//prefix for control name. Prefix controls that you want to save in history with the character defined below. 
//eg. a control with a name _structure will be saved while structure won't.
_flag = "_";
//history control definition. The name of the page it is on and the name of the control
//Below defines a control on PAGE1 with a name of history
_hctl = {
    page: "PAGE1",
    ctl: "history"
};
//The field used to identify a previous entry.
//Below uses the address as the identifier. It is the value of a control txtAddress on PAGE1
_hctlsrc = {
    page: "PAGE1",
    ctl: "txtAddress"
};

//*Configuration Section -- End*

_history = []; //global array storing the history of last 5 entered records.
_record = "desc"; //global variable, the key to retrieve the address from a record.
//save the values of the current entry into the history variable
//triggered by the Form onok event
function save_history(){
    var ctls, i, j, pgs, pg, m;
    var values = {}; //An associate array to store all the values
    pgs = ThisEvent.Object.Pages; //Reference to all the pages
    for (j = 1; j < pgs.Count + 1; j++) {
        //loop all the pages
        pg = pgs.Item(j);//current page
        ctls = pg.Controls;//all the controls on the current page
        for (i = 1; i < ctls.Count + 1; i++) {
            //loop all the controls 
            m = ctls.Item(i).name.toLowerCase();//In case the name control is not case sensitive.
            if (ctls.Item(i).name.substr(0, 1) == _flag) {
                //filter the controls, if it starts with "_", then remember it
                switch (ctls.Item(i).Type) {
                    //depending on the control's type, find the value need to be remembered.
                    //the data looks like, values[control name] =  "contro value"
                    case "COMBOBOX":
                        values[m] = ctls.Item(i).ListIndex;
                        break;
                    case "CHECKBOX":
                        values[m] = ctls.Item(i).Value;
                        break;
                    case "EDIT":
                        values[m] = ctls.Item(i).Value;
                        break;
                    case "RADIOBUTTON":
                        values[m] = ctls.Item(i).Value
                        break;
                }
            }
        }
    }
    
    
    //Now all the data are saved into the values variable
    //add the address to the values, so it can be populated for the history combobox
    values[_record] = pgs(_hctlsrc.page).Controls(_hctlsrc.ctl).Value;
    //Before saving values to the global history variable, check the length of the _history variable.
    //Only keep most recent 5 entries
    if (_history.length > 4) {
        _history.shift();//get rid of the oldest one
    }
    _history.push(values);//add the current one on the top
}


//Populate the current form with values from the selected entry in the history combobox
// triggered by the history combox onselchange event
//--ind, index of the history
function fill_form(ind){
    var ctls, i, j, pgs, pg, r, f, m;
    //reference to the pages and loop each page
    pgs = ThisEvent.Object.Parent.Parent.Pages;
    for (i = 1; i < pgs.Count + 1; i++) {
        pg = pgs.Item(i);//current page
        //To change the values of a control, the page the control is on must be activated.
        //if it is not the first page, activate the page
        if (i > 1) {
            pg.Activate();
        }
        //as the most recent entry is listed as the first item in the in the combox
        //To match the an item in the _history array using the index from the combox, the order need to be reversed.
        _history.reverse();
        r = _history[ind];//get the record from the _history
        _history.reverse();//reverse it back to normal order
        //reference to all the controls on the current page and loop through them
        //to populate values from history
        ctls = pg.Controls;
        for (j = 1; j < ctls.Count + 1; j++) {
            //get the name of the control and filter out those not saved.
            m = ctls.Item(j).name.toLowerCase();
            if (m.substr(0, 1) == _flag) {
                //if the control has ListIndex attribute, it must be a combobox
                if (ctls.Item(j).ListIndex) {
                    ctls.Item(j).SetFocus();
                    ctls.Item(j).ListIndex = r[m];
                }
                else {
                    //if it is not a combobox, it should have a Value field.
                    ctls.Item(j).Value = r[m]
                }
            }
        }
    }
    //Go back to the first page
    pgs.Item(1).Activate();
}


//Populate the history control with previous entries
//Triggered by Form onload event
function draw_history(){
    var ctl = ThisEvent.Object.Pages(_hctl.page).Controls(_hctl.ctl);//the history control
    var l = _history.length;
    ctl.Clear();//clear all existing items in it
    for (var i = 0; i < l; i++) {
        //populate the list, so that the last record are the first in the list
        r = _history[l - i - 1];
        ctl.AddItem(r[_record], i);//add the item in the list
    }
}

//Debugging tool, that will show the values in the _history variable in a pop up.
function debug(){
    var s, r, f;
    var l = _history.length;
    s = '';
    
    for (var i = 0; i < l; i++) {
        s += '\n History: ' + i + '\n';
        r = _history[i];
        for (f in r) {
            s += '    ' + f + ':' + r[f] + '---';
        }
    }
    Application.MessageBox(s);
}
